package gov.va.vamf.scheduling.direct.serializer;


import gov.va.vamf.scheduling.direct.utils.XSSSanitizer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.IOException;

public class XSSProtectionSerializer extends JsonSerializer<String> {

    @Override
    public void serialize(String output, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonProcessingException {

        String encoded = null;

        if (output != null){
            encoded = XSSSanitizer.sanitize(output);
            if (encoded != null) {
                encoded = unescapeValidCharacters(encoded);
            }
            gen.writeString(encoded);
        }
    }


    private String unescapeValidCharacters(String encoded) {
        String updatedStr = encoded.replaceAll("&amp;", "&").replaceAll("&lt;", "<").replaceAll("&gt;", ">");
        return updatedStr;
    }
}
